(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      6541,        208]*)
(*NotebookOutlinePosition[      7205,        231]*)
(*  CellTagsIndexPosition[      7161,        227]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(\(\(f[x_, y_]\)\(=\)\(g[\@\(x\^2 + y\^2\), \ 
        ArcTan[y\/x]]\)\(\ \ \ \)\( (*\ 
        es\ decir\ g[\[Rho]_, \[Theta]_] = 
          f[\[Rho]\ Cos[\[Theta]], \ \[Rho]\ Sin[\[Theta]]]\ *) \)\)\)], \
"Input"],

Cell[BoxData[
    \(g[\@\(x\^2 + y\^2\), ArcTan[y\/x]]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(Expand[
      Simplify[Simplify[
          D[f[x, y], {x, 2}] + 
              D[f[x, y], {y, 2}] /. {x \[Rule] \[Rho]\ Cos[\[Theta]], 
              y \[Rule] \[Rho]\ Sin[\[Theta]]}, \[Rho] > 0], \(-Pi\)/
            2 < \[Theta] < Pi/2]]\)\( (*\ 
      calculamos\ la\ laplaciana\ de\ f\ en\ un\ punto\ {x, 
          y}\ y\ expresamos\ dicho\ punto\ en\ coordenadas\ polares\ {\[Rho]\ \
Cos[\[Theta]], \[Rho]\ Sin[\[Theta]]}\ *) \)\)\)], "Input"],

Cell[BoxData[
    RowBox[{
      FractionBox[
        RowBox[{
          SuperscriptBox["g", 
            TagBox[\((0, 2)\),
              Derivative],
            MultilineFunction->None], "[", \(\[Rho], \[Theta]\), 
          "]"}], \(\[Rho]\^2\)], "+", 
      FractionBox[
        RowBox[{
          SuperscriptBox["g", 
            TagBox[\((1, 0)\),
              Derivative],
            MultilineFunction->None], "[", \(\[Rho], \[Theta]\), "]"}], 
        "\[Rho]"], "+", 
      RowBox[{
        SuperscriptBox["g", 
          TagBox[\((2, 0)\),
            Derivative],
          MultilineFunction->None], "[", \(\[Rho], \[Theta]\), 
        "]"}]}]], "Output"]
}, Open  ]],

Cell[BoxData[
    \(Clear["\<Global`*\>"]\)], "Input"],

Cell[BoxData[
    \(\(g[\[Rho]_, \[Theta]_] = 
        f[\[Rho]\ Cos[\[Theta]], \ \[Rho]\ Sin[\[Theta]]];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"Simplify", "[", 
        RowBox[{
          FractionBox[
            RowBox[{
              SuperscriptBox["g", 
                TagBox[\((0, 2)\),
                  Derivative],
                MultilineFunction->None], "[", \(\[Rho], \[Theta]\), 
              "]"}], \(\[Rho]\^2\)], "+", 
          FractionBox[
            RowBox[{
              SuperscriptBox["g", 
                TagBox[\((1, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(\[Rho], \[Theta]\), "]"}], 
            "\[Rho]"], "+", 
          RowBox[{
            SuperscriptBox["g", 
              TagBox[\((2, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(\[Rho], \[Theta]\), "]"}]}], 
        "]"}], \( (*\ 
        comprobamos\ el\ c\[AAcute]lculo\ anterior . \ 
            El\ resultado\ debe\ ser\ la\ laplaciana\ de\ f\ en\ el\ punto\ {\
\[Rho]\ Cos[\[Theta]], \[Rho]\ Sin[\[Theta]]}\ *) \)}]], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        SuperscriptBox["f", 
          TagBox[\((0, 2)\),
            Derivative],
          MultilineFunction->None], 
        "[", \(\[Rho]\ Cos[\[Theta]], \[Rho]\ Sin[\[Theta]]\), "]"}], "+", 
      RowBox[{
        SuperscriptBox["f", 
          TagBox[\((2, 0)\),
            Derivative],
          MultilineFunction->None], 
        "[", \(\[Rho]\ Cos[\[Theta]], \[Rho]\ Sin[\[Theta]]\), 
        "]"}]}]], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(\(f[x_, y_]\)\(=\)\(g[\@\(x\^2 + y\^2\), \ 
        2\ \ ArcTan[
            y\/\(x + \@\(x\^2 + y\^2\)\)]]\)\(\ \)\( (*N\[OAcute]tese\ que\ \
la\ funci\[OAcute]n\ g\ es\ la\ expresi\[OAcute]n\ de\ la\ funci\[OAcute]n\ f\
\ en\ coordenadas\ polares*) \)\)\)], "Input"],

Cell[BoxData[
    \(Expand[
      Simplify[Simplify[
          D[f[x, y], {x, 2}] + 
              D[f[x, y], {y, 2}] /. {x \[Rule] \[Rho]\ Cos[\[Theta]], 
              y \[Rule] \[Rho]\ Sin[\[Theta]]}, \[Rho] > 
            0], \(-Pi\) < \[Theta] < Pi]]\)], "Input"],

Cell[BoxData[
    \(Simplify[
      D[\ ArcTan[y\/x], x] - 
        D[2\ \ ArcTan[y\/\(x + \@\(x\^2 + y\^2\)\)], x]]\)], "Input"],

Cell[BoxData[
    \(Simplify[
      D[\ ArcTan[y\/x], y] - 
        D[2\ \ ArcTan[y\/\(x + \@\(x\^2 + y\^2\)\)], y]]\)], "Input"],

Cell[BoxData[
    \(Simplify[
      D[f[x, y], {x, 2}] /. {x \[Rule] \[Rho]\ Cos[\[Theta]], 
          y \[Rule] \[Rho]\ Sin[\[Theta]]}, \[Rho] > 0]\)], "Input"],

Cell[BoxData[
    \(Simplify[%, \(-Pi\)/2 < \[Theta] < Pi/2]\)], "Input"],

Cell[BoxData[
    \(Simplify[
      D[f[x, y], {y, 2}] /. {x \[Rule] \[Rho]\ Cos[\[Theta]], 
          y \[Rule] \[Rho]\ Sin[\[Theta]]}, \[Rho] > 0]\)], "Input"],

Cell[BoxData[
    \(Simplify[%, \(-Pi\)/2 < \[Theta] < Pi/2]\)], "Input"],

Cell[BoxData[
    \(Simplify[Out[3] + Out[5]]\)], "Input"],

Cell[BoxData[
    \(Simplify[D[\(x/\((x^2 + y^2)\)^1\)/2, x]]\)], "Input"],

Cell[BoxData[
    \(Simplify[D[y/\((x^2 + y^2)\), y]]\)], "Input"],

Cell[BoxData[
    \(Simplify[D[f[x, y], {x, 2}]]\)], "Input"]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1152}, {0, 788}},
WindowSize->{1144, 753},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->1.5
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 234, 5, 65, "Input"],
Cell[2013, 60, 68, 1, 55, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2118, 66, 473, 9, 94, "Input"],
Cell[2594, 77, 669, 21, 65, "Output"]
}, Open  ]],
Cell[3278, 101, 54, 1, 42, "Input"],
Cell[3335, 104, 120, 2, 42, "Input"],

Cell[CellGroupData[{
Cell[3480, 110, 999, 26, 128, "Input"],
Cell[4482, 138, 464, 14, 43, "Output"]
}, Open  ]],
Cell[4961, 155, 290, 5, 106, "Input"],
Cell[5254, 162, 268, 6, 68, "Input"],
Cell[5525, 170, 129, 3, 72, "Input"],
Cell[5657, 175, 129, 3, 72, "Input"],
Cell[5789, 180, 161, 3, 42, "Input"],
Cell[5953, 185, 73, 1, 42, "Input"],
Cell[6029, 188, 161, 3, 42, "Input"],
Cell[6193, 193, 73, 1, 42, "Input"],
Cell[6269, 196, 58, 1, 42, "Input"],
Cell[6330, 199, 74, 1, 42, "Input"],
Cell[6407, 202, 66, 1, 42, "Input"],
Cell[6476, 205, 61, 1, 42, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

